#ifdef SKINNING

	#version 120
	#extension GL_EXT_gpu_shader4 : enable          

#endif

#ifdef SKINNING
	uniform mat3 	boneMatrices[100];
#endif

#ifdef PSYSTEM

	uniform	vec4 	pparams[100]; 	
	uniform vec4	prevPParams[100];
	
	vec4			tpos;
	uniform vec4	data;
	varying float 	life;
	uniform vec4 	particleScale; //particleScale.w start rotation
	uniform vec3	camdir;
	
#else
	
	varying mat3	TBN;
	attribute vec4	binormal; 
	varying vec3	viewDir;
	uniform mat4	prevWTM;
	varying vec4 	vpos;
	
	uniform float 	bias;

#endif

varying vec2 	texcoord;
varying vec2 	texcoord1;

uniform vec2	tscale0;
uniform vec2	tscale1;

uniform vec2	tofs0;		// cambiare in uniform
uniform vec2	tofs1;		// cambiare in uniform

#ifdef BUMP2

	uniform vec2	tscale2;
	varying vec2 	texcoord2;
	uniform vec2	tofs2;

#endif

varying vec4 	pos;
uniform vec2	NF;
varying vec4	eyepos;

uniform vec3	campos;
uniform float	extintion;
uniform vec3  	SUN; 	// = colore del sole
uniform	vec3  	C0; 	// = cBr+cBm;	
uniform vec3  	C1; 	// = 1.0/(cBr+cBm);
uniform vec3  	cBr; 	// = RayLeigh
uniform float 	C2;	// = log(e)

uniform vec3 	fogColor;
uniform vec3 	inScatterColor;
uniform vec3 	sundir;
		
/*varying vec3 	Fex;
varying vec3 	Lin;*/

// ---------------------------- EXP FOG
varying vec4 	fogScat;
uniform float	fogNear;

uniform float cHeightFallof;//=0.0005;	// inserire dall'esterno
float cVolFogHeightDensityAtViewer=exp( cHeightFallof * -campos.y);
// -----------------------------------

////////////////////////////

// TAO

/*uniform sampler2D 	heightmap,
					colormap;
uniform vec3 invTerrainDim;
uniform float terrainMaxHeight;
uniform float maxRadius;
uniform float occScale;

varying float TAO;
*/
//////

attribute vec3 			s2_vertex;
attribute vec3			s2_normal;
attribute vec4			s2_binormal;
attribute vec4 			s2_color;
attribute vec4 			s2_secondaryColor;
attribute vec4			s2_texcoords; 

float ComputeVolumetricFog( vec3 cameraToWorldPos )
{
	float fogInt = max(length( cameraToWorldPos )-fogNear,0.0) * cVolFogHeightDensityAtViewer;
	
	if( abs( cameraToWorldPos.y) > 0.01)
	{
		float t = cHeightFallof * cameraToWorldPos.y;
		fogInt*= ( 1.0-exp( -t ) ) / t;
		
	}
	return fogInt;
}
		
vec2 ComputeFrame(float dt, vec2 nf)
{
	vec2 ofs=vec2(1.0,1.0)/nf;
	float frame=floor(dt*nf.x*nf.y);
	float row=floor(frame/nf.x);
	float col=floor(frame-nf.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

/*float ComputeTAO(vec3 wpos)
{
	vec2 heigthmapCoord = (wpos.xz*invTerrainDim.xz)+vec2(0.5,0.5);
	float tHeight=(texture2D(heightmap,heigthmapCoord.st).x-0.5)*terrainMaxHeight;
	float tDistance=wpos.y-tHeight;
	
	// get terrain sky visibility value from terrain
	float skyVisibility=texture2D(colormap,heigthmapCoord.st).a;

	// compute ambient occlusion basing on distance
	float d=clamp(tDistance/maxRadius,0.0,1.0);
	float visibility=mix(skyVisibility,1.0,d*d);	//0 max occlusion, 1 - no occlusion
	
	return min(visibility+occScale,1.0);
}*/

void main()
{  
	vec4 vertex=vec4(s2_vertex,1.0);

	#ifdef SKINNING

		vec4 index  		= s2_secondaryColor;//matrixIndices;
		vec4 weight 		= s2_color;//weights;
		vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
		
		mat4 TM=mat4(	0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,1.0);
		int j;
		for( int i = 0; i < 4; i++ )
		{
				// Apply influence of bone i
				
				j=int(index[i]);
				TM[0].xyz=boneMatrices[j][0];
				TM[1].xyz=boneMatrices[j][1];
				TM[2].xyz=cross(TM[0].xyz,TM[1].xyz);
				TM[3].xyz=boneMatrices[j][2];

				position = position + (TM * vertex) *weight[i];
		}
		gl_Position = gl_ModelViewProjectionMatrix * position;
		eyepos = gl_ModelViewMatrix * position;
		
	#else

		#ifdef PSYSTEM

			vec4 ppos=pparams[int(/*index.x*/s2_color.x)];
			life=ppos.w;
			
			if(data.w==0.0)
			{
				float scale=data.x + (data.y*(1.0-life));
				scale=clamp(scale,0.0,abs(scale))*0.5;
				scale+=scale*/*index.y*/s2_color.y;	
				ppos.w=1.0;
				
				// compute TAO ///
				//TAO=ComputeTAO(ppos.xyz);

				float angle=(/*index.y*/s2_color.y*6.28+particleScale.w)+(data.z*(1.0-life)*6.28);

				float cosa=cos(angle);
				float sina=sin(angle);

				tpos=gl_ModelViewMatrix * ppos;	

				vec3 tv=vertex.xyz;
				tv.x=(vertex.x*cosa)-(vertex.y*sina);
				tv.y=(vertex.x*sina)+(vertex.y*cosa);
				tpos.xyz=(tv.xyz*particleScale.xyz*scale + tpos.xyz);
			}
			else
			{
				vec4 prevpos=prevPParams[int(/*index.x*/s2_color.x)];
				prevpos.w=1.0;
							
				mat3 rTM,eTM;
				
				vec3 vel=ppos.xyz-prevpos.xyz;
				vec3 dir;
				vec3 vdir=normalize(vel);
				vec3 rgt;
				
				rgt=normalize(cross(vdir,camdir)/*rdot*/);
				dir=normalize(cross(vdir,rgt));
				
				rTM[2]=dir;
				rTM[0]=rgt;
				rTM[1]=vdir;
				
				float scale=length(vel);
				vec4 rpos;
				rpos.xyz=vertex.xyz*data.x;
				rpos.y+=(vertex.y*scale*particleScale.y);
			
				rpos.xyz=(rTM*rpos.xyz) + ppos.xyz;
				rpos.w=1.0;
				tpos=gl_ModelViewMatrix*rpos;
			}
			
			eyepos=tpos;
			gl_Position=gl_ProjectionMatrix*tpos;
			
		#else
				
			vec4 normal4   	= vec4( s2_normal, 0.0 );
			vec4 binormal4  = vec4( s2_binormal.xyz, 0.0 );
			vec4 tangent4   = vec4(cross(binormal4.xyz,normal4.xyz),0.0);
			binormal4.xyz*=s2_binormal.w;

			vec4 	outTangent,
					outNormal,
					outBinormal;
				
			outNormal=/*normalize(*/prevWTM*normal4/*)*/;
			outTangent=/*normalize(*/prevWTM*tangent4/*)*/;
			outBinormal=/*normalize(*/prevWTM*binormal4/*)*/;

			TBN[0]=outTangent.xyz;
			TBN[1]=outBinormal.xyz;
			TBN[2]=outNormal.xyz;

			// transform to world space
			vpos=prevWTM*vertex;
			
			// compute TAO ///
			//TAO=ComputeTAO(vpos.xyz);
			
			// compute view direction
			viewDir=campos-vpos.xyz;

	//		vertex.xyz=vertex.xyz+s2_normal.xyz*bias;		
			gl_Position = (gl_ModelViewProjectionMatrix)*vertex;//ftransform();
//			gl_Position.z-=bias;
			
			eyepos = gl_ModelViewMatrix * vertex;
			
			// compute fog ///////////////////////////////////////////////////
			vec3 vdir=normalize(eyepos.xyz);
			/*float cos=dot(-sundir,vdir);
			float F1=(1.0 + cos*cos*0.5);
			vec3 Br = cBr*F1*0.9;
		*/
			float delta=ComputeVolumetricFog(-viewDir);
			fogScat.a=exp(-extintion*delta);
			fogScat.rgb=(1.0-fogScat.a)*inScatterColor*fogColor*0.06;
				
		#endif

	#endif

	texcoord = s2_texcoords.st*tscale0 + tofs0;
	texcoord1 = s2_texcoords.st*tscale1 + tofs1;
	
	#ifdef BUMP2

		texcoord2 = s2_texcoords.st*tscale2 + tofs2;

	#endif
	
	pos=gl_Position;

}